//=============================================================================
// ApplyItemUserEffectRedefinition.js
// ----------------------------------------------------------------------------
// (C)2023 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2023/02/03 初版
// ----------------------------------------------------------------------------
// [Blog]   : http://kuroamekoubou.blog.fc2.com
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc 行動時MP＆TP回復
 * @target MZ
 * @author くろあめ
 *
 * @param tpGainMagniCri
 * @text クリティカル時TP回復倍率
 * @desc クリティカル発生時に回復するTPに設定値(%)の補正をかけます。
 * @default 150
 * @type number
 *
 * @param mpGainMagni
 * @text 通常攻撃時回復MP倍率
 * @desc 通常攻撃時命中時に回復するMPの割合（最大MP*設定%）を設定します。
 * @default 10
 * @type number
 *
 * @param mpGainLowest
 * @text 通常攻撃時回復MP最低値
 * @desc 通常攻撃命中時に回復するMPの最低保証値を設定します。
 * @default 5
 * @type number
 *
 * @param mpGainMagniCri
 * @text クリティカル時MP回復倍率
 * @desc クリティカル発生時に回復するTPに設定値(%)の補正をかけます。
 * @default 150
 * @type number
 *
 * @help
 * 以下の二つの機能を実装します
 *
 * ①
 * クリティカルが発生した場合、行動によって得るTPに補正をかけます。
 *
 * ②
 * 通常攻撃が命中した時、MPを一定値回復します。
 * 通常攻撃でなくても、スキル/アイテムのメモ欄に
 * <MpGainAct> と記述したスキル/アイテムが命中した時にはMPが回復します。
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
*/

(function() {

'use strict';
const script = document.currentScript;
const param = PluginManagerEx.createParameter(script);

    Game_Action.prototype.applyItemUserEffect = function(target) {
        
        const result = target.result();
        
        // MP回復処理
        if (this.isAttack() || this.checkMpGainAct(this.item())) { // 通常攻撃時のみ
            var gain_mp = Math.round(this.subject().mmp * param['mpGainMagni'] / 100);
            if(gain_mp < param['mpGainLowest']) gain_mp = param['mpGainLowest'];
            if (result.critical) {
                gain_mp = Math.round(gain_mp * param['mpGainMagniCri'] / 100);
            }
            this.subject().setMp(this.subject().mp + gain_mp);
        }
        
        // TP回復処置
        var gain_tp = Math.floor(this.item().tpGain * this.subject().tcr);
        if (result.critical) {
            gain_tp = Math.round(gain_tp * param['tpGainMagniCri'] / 100);
        }
        
        this.subject().gainSilentTp(gain_tp);
    };
    
    Game_Action.prototype.checkMpGainAct = function(item) {
        if(item && item.meta && item.meta.MpGainAct){
            return true;
        }
        return false;
    }
    
})();

